/*
	Zadatak: Vlakovi:
	--------------------------
	Za sakupiti neke bodove na ovom zadatku postoje tri osnovna rjeenja.

	1. Naivna simulacija sekundu po sekundu. Tu se radi o doslovnom implementiranju onoga 
	to se u zadatku trai tako da u svakoj sekundi pomaknemo sve vlakove koji se u toj 
	sekundi mogu pomaknuti. Sloenost takvog algoritma je O( L * V ) i nosi 50% bodova.

	2. Simulacija po dogaajima. Za ovo je potrebno primijetiti kako nisu sve sekunde 
	jednako vazne. Sekunde u kojima nijedan vlak ne kree i ne staje smatramo nezanimljivim 
	i koncentriramo se na preostale. Stalno raunamo sljedei zanimljiv trenutak kao najblizi 
	trenutak u kojem neki vlak staje/kree i pomaknemo sve aktivne vlakove za neki fiksni 
	delta. Nakon toga provjerimo jesu li neki vlakovi postali aktivni i njih uzimamo u obzir 
	pri traenju sljedeeg zanimljivog trenutka. Ovakav algoritam ima sloenost O( V^2*S) jer 
	imamo maksimalno V * S zanimljivih trenutaka i svaki puta prolazimo maksimalno V vlakova 
	kako bismo izraunali sljedei zanimljiv trenutak i pomaknuli aktivne vlakove. 
	To rjeenje nosi 80% bodova.

	3. Ubrzanje. Jedino to treba dodati prethodnom rjeenju je brzo raunanje zanimljivih trenutaka.  
	To se lako implementira koritenjem neke strukture podataka kao to je prioritetni red. U redu drimo 
	sve vlakove i njihove nadolazee trenutke stajanja ili pokretanja. Kada nas zanima sljedei zanimljiv 
	trenutak jednostavno uzmemo onaj s vrha prioritetnog reda. U tom zanimljivom trenutku moe sudjelovati 
	vie vlakova, no to nas ne brine. Jednostavno sve takve provjerimo hoe li stati ili se nastaviti kretati, 
	kao i stanicu iza njih u koliko u njoj ima vlakova koji bi mogli izai na prugu. Takve vlakove 
	(koji ostaju/postaju aktivni) ubacujemo u prioritetni red i nastavljamo s algoritmom.
*/

#include <cstdio>
#include <cstring>

#include <set>
#include <queue>
#include <vector>
#include <algorithm>

using namespace std;

#define MAXV 5005
#define MAXS 5005

int L, S, V;
int s[ MAXS ];
int v[ MAXV ];
int sol[ MAXV ];
int dest[ MAXV ];
int active[ MAXV ];

struct vlak {
  int id;
  int left;

  vlak( int ID, int T ) {
    id = ID; left = T; 
  }
};

bool operator<( vlak a, vlak b ) {
  if( a.left == b.left ) return ( a.id < b.id );
  return ( a.left < b.left );
}

struct pqs {
  set< vlak > s;
  int shift;

  int empty() { return s.empty(); }
  int getmin() { return s.begin()->left + shift; }

  void push( int id, int left, int d ) { 
    s.insert( vlak( id, left - shift ) ); 
    dest[id] = d;
    active[id] = 1; 
  }

  vlak pop() { 
    vlak ret = *s.begin(); s.erase( s.begin() ); 
    active[ret.id] = 0; 
    return ret; 
  }
  
  void add( int dt ) { shift += dt; }
} pq;

queue< int > qs[ MAXV ];
vector< vlak > now;

int main( void )
{
  scanf( "%d%d%d", &L, &S, &V );

  for( int i = 0; i < S; ++i )
    scanf( "%d", &s[i] );

  for( int i = 0; i < V; ++i ) {
    scanf( "%d", &v[i] );
    int stop = lower_bound( s, s + S, v[i] ) - s;
    pq.push( i, s[stop] - v[i], stop );
  }

  int ctime = 0;

  while( !pq.empty() ) {
    int cmin = pq.getmin();
    pq.add( -cmin );

    ctime += cmin;
    now.clear();

    while( !pq.empty() && pq.getmin() == 0 ) {
      vlak curr = pq.pop();
      if( dest[curr.id] == S-1 ) sol[curr.id] = ctime;
      now.push_back( curr );
    }

    for( int i = 0; i < now.size(); ++i ) {
      vlak curr = now[i];
      int stop = dest[curr.id];

      if( !qs[stop-1].empty() ) { 
	pq.push( qs[stop-1].front(), s[stop] - s[stop-1], stop );
	qs[stop-1].pop();
      }
    }

    for( int i = 0; i < now.size(); ++i ) {
      vlak curr = now[i];
      int stop = dest[curr.id];
      
      if( stop != S-1 && ( !active[curr.id+1] || dest[curr.id+1] > stop+1 ) && qs[stop].empty() ) {
	pq.push( curr.id, s[stop+1] - s[stop], stop+1 );
      }
      else qs[stop].push( curr.id );
    }
  }

  for( int i = 0; i < V; ++i )
    printf( "%d\n", sol[i] );

  system ("pause");
  return 0;
}
